// slfwork.cpp: Implementierungsdatei
//

#include "stdafx.h"
#include "UbVoicePatch.h"
#include "slfwork.h"

#include "stdafx.h"
#include <stdio.h>
#include <string.h>
#include "common.h"
#include "Progress.h"
#include "UbVoicePatchDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// Dialogfeld slfwork 


slfwork::slfwork(CWnd* pParent /*=NULL*/)
	: CDialog(slfwork::IDD, pParent)
{
	//{{AFX_DATA_INIT(slfwork)
	m_extract = _T("");
	//}}AFX_DATA_INIT
	memset(basedir, 0, sizeof(basedir));
	count = 0;
	LastError = 0;
	li = NULL;
	slffile = NULL;
}


void slfwork::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(slfwork)
	DDX_Control(pDX, IDC_PROGRESS, m_progress);
	DDX_Text(pDX, IDC_EXTRACT, m_extract);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(slfwork, CDialog)
	//{{AFX_MSG_MAP(slfwork)
		// HINWEIS: Der Klassen-Assistent fgt hier Zuordnungsmakros fr Nachrichten ein
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// Behandlungsroutinen fr Nachrichten slfwork 


slfwork::~slfwork()
{
	if (li)
	{
		delete [] li;
		li = NULL;
	}
	if (slffile)
	{
		fclose(slffile);
		slffile = NULL;
	}
}

bool slfwork::Load(CString filename)
{
// Open the slf File
	slffile = fopen(filename, "rb");
	if (slffile == (FILE *)NULL)
	{
		LastError = FILE_NOT_FOUND;
		return(FALSE);
	}
// Get the base directory of the archive
	char header[532];
	if (fread(header, 1, 532, slffile) != 532)
	{
		fclose(slffile);
		LastError = FILE_BUGGY;
		return(FALSE);
	}
	memcpy(&basedir, &header[256], 256);
// Get the number of files in the archive
	memcpy(&count, &header[512], 4);
// Load the dictionary temporarily into memory
	DWORD dictionarylength = count*280;
	char *dictionary = new char[dictionarylength];
	if (!dictionary)
	{
		fclose(slffile);
		LastError = MEMORY_ALLOCATION_FAILED;
		return(FALSE);
	}
	fseek(slffile, -(int)dictionarylength, SEEK_END);
	if (fread(dictionary, 1, dictionarylength, slffile) != dictionarylength)
	{
		delete [] dictionary;
		fclose(slffile);
		LastError = FILE_BUGGY;
		return(FALSE);
	}
// Parse the dictionary and store all important stuff into the *li array
	li = new ListItem[count];
	if (!li)
	{
		delete [] dictionary;
		fclose(slffile);
		LastError = MEMORY_ALLOCATION_FAILED;
		return(FALSE);
	}
	for (int i=0; i<count; i++)
	{
		memcpy(li[i].name, dictionary + 280*i, 256);
		char *tempc = strrchr(li[i].name, '\\');
		if (tempc)
		{
			char tempdir[256];
			tempc++;
			memcpy(&tempdir, li[i].name, tempc-li[i].name);
			tempdir[tempc-li[i].name] = 0;
			strcpy(li[i].name, tempc);
			strcpy(li[i].dir, basedir);
			strcat(li[i].dir, tempdir);
		}
		else
			strcpy(li[i].dir, basedir);
		memcpy(&li[i].pos, dictionary + 280*i + 256, 4);
		memcpy(&li[i].length, dictionary + 280*i + 260, 4);
	}	
// Everthing went fine, now kill the dictionary and return
	delete [] dictionary;
	return(TRUE);
}

int slfwork::Extract(CString wildcard, CString m_output, CString filename)
{
	char outname[256];
	FILE *outfile;
	int extracted=0;
	Load(filename);


	CDialog::Create(IDD_PROGRESS);	//fortschrittsdialog anzeigen

	m_progress.SetRange(0, count);	//gre von fortschrittsanzeige einstellen
	
	
	for (int i=0; i<count; i++)
	{
	m_progress.StepIt();		//fortschrittsanzeige erhhen
	m_extract=_T("searching...");
	SetDlgItemText(IDC_EXTRACT, m_extract);

	CString dummy = _T("");
// Check whether the file is matched by the given wildcard
		if (WildcardMatch(li[i].name, wildcard)==TRUE)	//berprfen ob richtige datei 
		{
			dummy = m_output;
			dummy += _T("\\");
			dummy += li[i].name;
			m_extract = _T("extracting: "); 
			m_extract += li[i].name;
			SetDlgItemText(IDC_EXTRACT, m_extract);
			strcpy(outname, dummy);
			outfile=fopen(outname, "wb");
			char *copybuf = new char[li[i].length];
			fseek(slffile, li[i].pos, SEEK_SET);
			fread(copybuf, 1, li[i].length, slffile);
			fwrite(copybuf, 1, li[i].length, outfile);
			delete [] copybuf;
			fclose(outfile);
			extracted++;
			
		}
	}

	CWnd::DestroyWindow();	//fortschrittsdialog schlieen
	
	if (!extracted)
		LastError = NO_FILES_EXTRACTED;
	return(extracted);
}

bool slfwork::WildcardMatch(CString n, CString w)
{
	if (n.Left(3) == w && (n.Right(3) == _T("WAV") || n.Right(3) == _T("GAP")))	//berprfen ob richtige wavdatei
		return(TRUE);
	else 
		return(FALSE);

	/*
	if (!stricmp(n, w))
		return(TRUE);
// Q&D wildcard matching (How does one do the real stuff on Windows??!)
	if (!strcmp(w, "*") || !strcmp(w, "*.*"))
		return(TRUE);
	char *wext = strrchr(w, '.') + 1;
	char wname[256];
	memcpy(wname, w, wext-w-1); wname[wext-w-1] = 0;
	if (strchr(wext, '*'))
		return(FALSE);

	char *next = strrchr(n, '.') + 1;
	char nname[256];
	memcpy(nname, n, next-n-1); nname[next-n-1] = 0;

	if (!strcmp(wname, "*") && !stricmp(next, wext))
		return(TRUE);

	return(FALSE);*/
}

char *slfwork::GetItemName(int i)
{
	if (!li || i >= count)
	{
		LastError = NO_LIST_LOADED;
		return(NULL);
	}
	static char r[256];
	strcpy(r, li[i].name);
	return(r);
}

char *slfwork::GetItemDir(int i)
{
	if (!li || i >= count)
	{
		LastError = NO_LIST_LOADED;
		return(NULL);
	}
	static char r[256];
	strcpy(r, li[i].dir);
	return(r);
}

int slfwork::GetItemLength(int i)
{
	if (!li || i >= count)
	{
		LastError = NO_LIST_LOADED;
		return(FALSE);
	}
	return(li[i].length);
}

char *slfwork::LastErrorString()
{
	static char r[256];
	switch(LastError)
	{
	case FILE_NOT_FOUND:
		strcpy(r, "File not found");
		break;
	case FILE_BUGGY:
		strcpy(r, "File is buggy");
		break;
	case MEMORY_ALLOCATION_FAILED:
		strcpy(r, "Memory allocation failed");
		break;
	case NO_LIST_LOADED:
		strcpy(r, "No list loaded");
		break;
	case NO_FILES_EXTRACTED:
		strcpy(r, "No files extracted");
		break;
	case FILE_NOT_CREATED:
		strcpy(r, "File not created");
		break;
	default:
		strcpy(r, "unknown");
		break;
	}

	return(r);
}
