/******************************************************************************
*
* .SLF Utils
* Copyright (C) 2000 by Athman Boukhaoua
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public License
* as published by the Free Software Foundation; either version 2
* of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program; if not, write to the Free Software
* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*
******************************************************************************/


#include <stdio.h>
#include <conio.h>
#include <string.h>
#include "common.h"
#include "slf.h"
#include "slfworker.h"

int main(int argc, char *argv[])
{
	int rval;
	SlfWorker sw;

	if (argc < 2)
	{
		usage();
		return(1);
	}

	if (!strcmp(argv[1], "l"))
	{
// File listing
		if (argc < 3)
		{
			usage();
			return(1);
		}
		char *filename = argv[2];

		rval = sw.Load(filename);
		if (!rval)
		{
			printf("Error \"%s\" while opening\n", sw.LastErrorString());
			return(1);
		}

		int c = sw.GetCount();
		char *name, *dir;
		int length;
		printf("           %-15s    %8s            %-15s      \n", "Name", "Length", "Directory");
		printf("\n");
		for (int i=0; i<c; i++)
		{
			name = sw.GetItemName(i);
			length = sw.GetItemLength(i);
			dir = sw.GetItemDir(i);
			printf("  %-25s  %8d       %-25s\n", name, length, dir);
			if (!((i+2)%23))
			{
				printf("Press a key to continue\r");
				int c = getch();
				if (c == 27 || c == 3)
					return(0);
			}
		}
	}
	else if (!strcmp(argv[1], "d"))
	{
// File listing
		if (argc < 4)
		{
			usage();
			return(1);
		}
		char *filename = argv[2];
		char *txtname = argv[3];

		rval = sw.Load(filename);
		if (!rval)
		{
			printf("Error \"%s\" while opening\n", sw.LastErrorString());
			return(1);
		}

		int c = sw.GetCount();
		char *name, *dir;
		int length;
		FILE *txtfile = fopen(txtname, "wt");
		if (txtfile == (FILE *)NULL)
		{
			printf("Couldn't create %s\n", txtname);
			return(FALSE);
		}
		fprintf(txtfile, "           %-15s    %8s            %-15s      \n", "Name", "Length", "Directory");
		fprintf(txtfile, "\n");
		for (int i=0; i<c; i++)
		{
			name = sw.GetItemName(i);
			length = sw.GetItemLength(i);
			dir = sw.GetItemDir(i);
			fprintf(txtfile, "  %-25s  %8d       %-25s\n", name, length, dir);
		}
		fclose(txtfile);
		printf("Wrote %d lines to %s\n", c, txtname);
	}
	else if (!strcmp(argv[1], "x"))
	{
// Extract one or several files
		if (argc < 4)
		{
			usage();
			return(1);
		}
		char *filename = argv[2];
		char *wildcard = argv[3];

		rval = sw.Load(filename);
		if (!rval)
		{
			printf("Error \"%s\" while opening\n", sw.LastErrorString());
			return(1);
		}
		rval = sw.Extract(wildcard);
		if (!rval)
		{
			printf("Error \"%s\" while extracting\n", sw.LastErrorString());
			return(1);
		}
		printf("Successfully extracted %d files\n", rval);
	}
	else
		usage();

	return(0);
}

bool usage()
{
	printf("\n");
	printf("\t\t\tSLF Utils v1.0\n");
	printf("\n");
	printf("Usage:\n");
	printf("slf <command> <slf-file> [options]\n");
	printf("\n");
	printf("Possible commands:\n");
	printf("\tl\tLists all files in the archive\n");
	printf("\t\tExample:\tslf l speech.slf\n");
	printf("\n");
	printf("\td\tWrites a list of all files in the archive into a text file\n");
	printf("\t\tExample:\tslf d speech.slf speech-list.txt\n");
	printf("\n");
	printf("\tx\tExtracts one or several files out of the archive\n");
	printf("\t\tExample:\tslf x speech.slf ambient1.wav\n");
	printf("\t\t\t\tslf x speech.slf *.sti\n");
	printf("\n");
	printf("Note: You may only use wildcards of the type *.wav, *.sti, *.txt etc.\n");
	printf("      (and of course *.*)\n");
	printf("      Advanced wildcards like a*.*, *1.wav etc. are _not_ possible\n");
	printf("\n");
	return(TRUE);
}


